enum EExportMode {
    SVG = 'svg',
    REACT_COMPONENT = 'react-component',
    PNG = 'png',
}

export default EExportMode;

export const EXPORT_MODES = Object.values(EExportMode);

export function isExportMode(candidate: unknown): candidate is EExportMode {
    return EXPORT_MODES.some(v => v === candidate);
}
