/* eslint-disable @typescript-eslint/naming-convention */

/**
 * Поверхностная типизация
 */
declare module 'compact-tl' {
    // неизвестен тип AST compact-tl
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    export type AST = any;

    export type Processor = (ast: AST, compiler: Compiler) => string;

    export class Parser {
        constructor(str: string);
    }

    export class AstBuilder {
        constructor();

        registerBlockSection(blockName: string, sectionName: string);

        build(parser: Parser): AST;
    }

    export class Compiler {
        constructor();

        registerBlockHelper(blockName: string, processor: Processor);
        registerHelper(blockName: string, processor: Processor);

        generateExpression(exp: unknown): string;
        compileThread(exp: unknown): string;
        compileThread(exp: unknown): string;
        compile(ast: AST): string;
    }
}
