import path from 'path';
import fse from 'fs-extra';

/**
 * Замените путь на @yandex-data-ui/i18n-ts
 */
import {Builder} from '../build';

const TRAVEL_TANKER_PROJECT = 'travel_frontend';
const TRAVEL_TANKER_BRANCH = 'master';

const BUILD_FOLDER = path.join(__dirname, 'keysets');
const EXAMPLE_SOURCE = path.join(__dirname, 'translates.example.json');

(async function exampleBuildTranslates(): Promise<void> {
    const translations = await fse.readJSON(EXAMPLE_SOURCE);

    const builder = new Builder({
        outFolder: BUILD_FOLDER,
        tankerLinkOptions: {
            base: 'https://tanker.yandex-team.ru',
            branch: TRAVEL_TANKER_BRANCH,
            project: TRAVEL_TANKER_PROJECT,
        },
        i18nBackwardCompatibility: true,
        i18nBackwardCompatibilityFileName: 'old-compatibility-index',
    });

    await builder.build(translations);
})().catch(console.error);
