export function getLiteralOrIdentifierValue(j, ast, node) {
    if (node.type === 'StringLiteral') {
        return node.value;
    } else if (node.type === 'Identifier') {
        const variableDeclaration = ast
            .find(j.VariableDeclarator, {
                id: {name: node.name},
            })
            .at(0)
            .get();

        const value = variableDeclaration.node.init.value;

        j(variableDeclaration).remove();

        return value;
    }

    return null;
}
