interface IBuildParams {
    description?: string;
    link?: {
        url: string;
        name: string;
    };
}

export default class JSDocBuilder {
    build({description, link}: IBuildParams): string {
        const descriptionLine = description ? ` * ${description}\n` : '';
        const linkLine = link ? ` * {@link ${link.url} ${link.name}}\n` : '';

        return '/**\n' + descriptionLine + linkLine + ' */';
    }
}
