import ELanguages from '../../types/ELanguages';
import {TParams} from '../types/TParams';
import ITranslationLangKey from '../../types/ITranslationLangKey';

import ContentBuilder from '../ContentBuilder/ContentBuilder';
import BodyExtractor from '../BodyExtractor/BodyExtractor';
import ParamsExtractor from '../ParamsExtractor/ParamsExtractor';

interface IPreparedKey {
    /**
     * Используемые в ключе параметры
     */
    params: TParams;
    /**
     * Тело ключа, после типографики и преобразованный в js код (только тело функции)
     */
    body: string;
    /**
     * Язык перевода
     */
    lang: ELanguages;
    /**
     * Текст (подготовленный) в Танкере для языка lang
     */
    text: string;
    /**
     * Текст (оригинальный) в Танкере для языка lang
     */
    sourceText: string;
}

/**
 * Собирает из ключа данные для KeyFunctionBuilder
 */
export default class KeyPreparer {
    prepare({lang, text, sourceText}: ITranslationLangKey): IPreparedKey {
        const contentBuilder = new ContentBuilder({
            lang,
        });
        const content = contentBuilder.compile(text);

        const bodyExtractor = new BodyExtractor();
        const body = bodyExtractor.extract(content);

        const paramsExtractor = new ParamsExtractor();
        const params = paramsExtractor.extract(body);

        return {
            params,
            body,
            lang,
            text,
            sourceText,
        };
    }
}
