import {parse} from '@babel/parser';
import traverse from '@babel/traverse';

import {
    isBinaryExpression,
    isIdentifier,
    isExpressionStatement,
} from '@babel/types';
import {EParamType, TParams} from '../types/TParams';

/**
 * Извлекает все вызовы параметров объекта params
 */
export default class ParamsExtractor {
    extract(code: string): TParams {
        const ast = parse(code);

        const params: TParams = {};

        traverse(ast, {
            MemberExpression({parent, node: {object, property}}) {
                if (
                    !isIdentifier(object) ||
                    object.name !== 'params' ||
                    !isIdentifier(property)
                ) {
                    return;
                }

                if (isBinaryExpression(parent) && parent.operator === '%') {
                    params[property.name] = EParamType.NUMBER;

                    return;
                }

                if (isExpressionStatement(parent)) {
                    params[property.name] = EParamType.STRING;

                    return;
                }

                if (
                    params[property.name] !== undefined &&
                    params[property.name] !== EParamType.OTHER
                ) {
                    return;
                }

                params[property.name] = EParamType.OTHER;
            },
        });

        return params;
    }
}
