/* eslint-disable camelcase */

import ELanguages from '../../../types/ELanguages';

import ITranslationsRequest from './ITranslationsRequest';

export default interface ITranslationsResponse {
    export_info: {
        request: ITranslationsRequest;
        name: string;
        branch: string;
    };
    keysets: {
        [keysetName: string]: {
            keys: {
                [keyName: string]: {
                    info: {
                        context: string;
                        is_plural: boolean;
                        references: string;
                    };
                    translations: Record<
                        ELanguages,
                        {
                            status: 'approved' | 'translated';
                            translator_comment: string;
                            author: string;
                            change_date: string;
                            form: string;
                        }
                    >;
                };
            };
            meta: {
                languages: ELanguages[];
                context: string;
            };
        };
    };
}
