import ELanguages from './ELanguages';
import ITankerLinkOptions from './ITankerLinkOptions';

export default interface IBuilderOptions {
    /**
     * Путь до папки с результатами сборки
     */
    outFolder: string;

    /**
     * Язык оригинала, используется для параметров ключа
     * @default ELanguages.RU
     */
    originalLang?: ELanguages;

    /**
     * Имя переменной по которой выбирается язык при сборке
     * @default __BUILD_LANG__
     */
    langConstantName?: string;

    /**
     * Параметры для формирования ссылки на танкер
     * При отсутствии параметров ссылка не формируется
     */
    tankerLinkOptions?: ITankerLinkOptions;

    /**
     * Функция для подготовки ключей
     * @param key принимает ключ
     * @return имя функции
     */
    prepareKey?(key: string): string;

    /**
     * Собрать функцию i18n как в ymaps-tanker
     */
    i18nBackwardCompatibility?: boolean;

    /**
     * Имя файла с функцией i18n
     * @default index
     */
    i18nBackwardCompatibilityFileName?: string;
}
