import getFunctionName from '../getFunctionName';

type TParams = Record<string, number | string | boolean>;

interface ICreateUnsafeDynamicKeysetParams {
    /**
     * Функция обработки ошибки
     * @param e ошибка
     * @param keyName имя ключа
     */
    onError(e: Error, keyName: string): void;

    /**
     * Функция для подготовки ключей
     * @param key принимает ключ
     * @return имя функции
     */
    prepareKey?(key: string): string;
}

/**
 * Создает декоратор для динамического извлечения ключей из кейсета
 */
export default function createUnsafeDynamicKeyset({
    onError,
    prepareKey = getFunctionName,
}: ICreateUnsafeDynamicKeysetParams) {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    return (keyset: any, keyName: string) => {
        return (params?: TParams): string => {
            try {
                return keyset[prepareKey(keyName)](params);
            } catch (e) {
                if (e instanceof Error) {
                    onError(e, keyName);
                }

                return '';
            }
        };
    };
}
