import camelCase from 'lodash/camelCase';

import tsKeywords from './tsKeywords';

export default function getFunctionName(keyName: string): string {
    const replaced = keyName.replace(/-/g, '_dash_').replace(/\./g, '_dot_');
    const functionName = camelCase(replaced);

    if (tsKeywords.has(functionName)) {
        return `_${functionName}`;
    }

    return functionName;
}
