import React, {isValidElement, ReactElement, ReactNode} from 'react';

type TParamsWithReactNode<T> = {[P in keyof T]: T[P] | ReactNode};

const SEPARATOR = '%%';
const MARKER = '__';

/**
 * Декоратор, который позволяет использовать Реакт элементы в параметрах ключей из переводов
 */
export default function insertJSXIntoKey<
    P extends Record<string, number | string | boolean>,
>(keyFunction: (params: P) => string) {
    return (params: TParamsWithReactNode<P>): ReactElement => {
        const paramsWithPlaceholder = Object.entries(params).reduce(
            (acc, [paramName, param]) => {
                if (isValidElement(param)) {
                    return {
                        ...acc,
                        [paramName]: `${SEPARATOR}${MARKER}${paramName}${SEPARATOR}`,
                    };
                }

                return {
                    ...acc,
                    [paramName]: param,
                };
            },
            {} as P,
        );

        return (
            <React.Fragment key={keyFunction.name}>
                {keyFunction(paramsWithPlaceholder)
                    .split(SEPARATOR)
                    .filter((part: string) => part !== '')
                    .map((part: string) => {
                        if (part.startsWith(MARKER)) {
                            const paramName = part.substr(MARKER.length);

                            return (
                                <React.Fragment key={paramName}>
                                    {params[paramName]}
                                </React.Fragment>
                            );
                        }

                        return part;
                    })}
            </React.Fragment>
        );
    };
}
