/* eslint-disable security/detect-non-literal-require, security/detect-non-literal-fs-filename */
const path = require('path');
const fs = require('fs');
const webpack = require('webpack');
const webpackDevMiddleware = require('webpack-dev-middleware');
const webpackHotMiddleware = require('webpack-hot-middleware');
// eslint-disable-next-line import-helpers/order-imports
const webpackHotServerMiddleware = require('webpack-hot-server-middleware');

const webpackSettingsPath = path.resolve(__dirname, '..', 'webpack');
const clientWebpackConfig = require(`${webpackSettingsPath}/client.webpack.config`);
const serverWebpackConfig = require(`${webpackSettingsPath}/server.webpack.config`);
const {buildPath} = require(`${webpackSettingsPath}/utilities/getPathParams`);

const {isEmpty: _isEmpty} = require('lodash');

let buildDevMiddlewares = {};

const preventExtractPluginStats = webpackCompiler => {
    const shouldPickStatChild = child =>
        !child.name.includes('mini-css-extract-plugin');

    webpackCompiler.hooks.done.tap('mini-css-extract-plugin', stats => {
        const statsChildren = stats.compilation.children;

        if (Array.isArray(statsChildren)) {
            stats.compilation.children = statsChildren.filter(child =>
                shouldPickStatChild(child),
            );
        }
    });
};

const createBuildFolder = () => {
    const isExistsBuildFolder = fs.existsSync(buildPath);

    if (isExistsBuildFolder === false) {
        fs.mkdirSync(buildPath);
    }
};

module.exports = () => {
    const canStartWebpackBuild = _isEmpty(buildDevMiddlewares);

    if (canStartWebpackBuild) {
        createBuildFolder();

        const webpackMultiCompiler = webpack([
            clientWebpackConfig,
            serverWebpackConfig,
        ]);
        const [clientWebpackCompiler] = webpackMultiCompiler.compilers;

        const webpackDevMiddlewareInstance = webpackDevMiddleware(
            webpackMultiCompiler,
            {
                serverSideRender: true,
                stats: {
                    env: true,
                    colors: true,
                    errors: true,
                    chunks: false,
                    assets: false,
                    modules: false,
                    errorDetails: false,
                },
            },
        );

        preventExtractPluginStats(clientWebpackCompiler);

        const webpackHotMiddlewareInstance = webpackHotMiddleware(
            clientWebpackCompiler,
        );

        const webpackHotPdfControllerMiddlewareInstance = webpackHotServerMiddleware(
            webpackMultiCompiler,
            {
                chunkName: 'pdfController',
                serverRendererOptions: {},
            },
        );

        const webpackHotServerMiddlewareInstance = webpackHotServerMiddleware(
            webpackMultiCompiler,
            {
                chunkName: 'renderServer',
                serverRendererOptions: {},
            },
        );

        buildDevMiddlewares = {
            webpackDevMiddlewareInstance,
            webpackHotMiddlewareInstance,
            webpackHotServerMiddlewareInstance,
            webpackHotPdfControllerMiddlewareInstance,
        };
    }

    return buildDevMiddlewares;
};
