import axios, {AxiosInstance} from 'axios';

import EHeaderName from '../../constants/headers';

import TRequest from 'server/types/TRequest';
import EServiceName from '../../types/EServiceName';
import IGetHotelOrderRequest from './types/getHotelOrder/IGetHotelOrderRequest';
import IGetHotelOrderResponse from './types/getHotelOrder/IGetHotelOrderResponse/IGetHotelOrderResponse';
import {IGetAdminOrderResponse} from './types/getAdminOrder/IGetAdminOrderResponse';
import {IGetAdminOrderRequest} from './types/getAdminOrder/IGetAdminOrderRequest';
import IGetOrderForBusinessTripDocRequest from './types/getOrderForBusinessTripDoc/IGetOrderForBusinessTripDocRequest';
import IGetOrderForBusinessTripDocResponse from './types/getOrderForBusinessTripDoc/IGetOrderForBusinessTripDocResponse';

import getServiceApiEntry from 'server/utilities/getServiceApiEntry';
import getServiceTVMTicket from 'server/utilities/getServiceTVMTicket';

export default class TravelApi {
    private axiosInstance: AxiosInstance;

    constructor(req: TRequest) {
        this.axiosInstance = axios.create({
            baseURL: getServiceApiEntry(req, EServiceName.TRAVEL),
            headers: {
                [EHeaderName.X_YA_SERVICE_TICKET]: getServiceTVMTicket(
                    req,
                    EServiceName.TRAVEL,
                ),
                [EHeaderName.X_YA_USE_CAMELCASE]: true,
            },
        });
    }

    async getHotelOrder(
        params: IGetHotelOrderRequest,
    ): Promise<IGetHotelOrderResponse> {
        const {data} = await this.axiosInstance.get<IGetHotelOrderResponse>(
            'booking_flow/v1/admin/get_order',
            {
                params,
            },
        );

        return data;
    }

    async getAdminOrder(
        params: IGetAdminOrderRequest,
    ): Promise<IGetAdminOrderResponse> {
        const {data} = await this.axiosInstance.get<IGetAdminOrderResponse>(
            'admin/v1/get_order_no_auth',
            {
                params,
            },
        );

        return data;
    }

    async getOrderForBusinessTripDoc(
        params: IGetOrderForBusinessTripDocRequest,
    ): Promise<IGetOrderForBusinessTripDocResponse> {
        const {data} = await this.axiosInstance.get<
            IGetOrderForBusinessTripDocResponse
        >('admin/v1/get_order_for_business_trip_doc', {params});

        return data;
    }
}
