import IPrice from 'types/common/IPrice';

export enum EBusDocumentType {
    RU_PASSPORT = 'RU_PASSPORT',
    RU_BIRTH_CERTIFICATE = 'RU_BIRTH_CERTIFICATE',
    RU_INTERNATIONAL_PASSPORT = 'RU_INTERNATIONAL_PASSPORT',
    RU_FOREIGN_PASSPORT = 'RU_FOREIGN_PASSPORT',
}

export enum EBusGender {
    MALE = 'MALE',
    FEMALE = 'FEMALE',
}

export enum EBusTicketType {
    FULL = 'FULL',
    CHILD = 'CHILD',
    BAGGAGE = 'BAGGAGE',
}

export interface IBusPassenger {
    firstName: string;
    middleName?: string;
    lastName: string | null;
    birthday: string;
    gender?: EBusGender;
    genderPartnerId: string;
    citizenship?: string;
    citizenshipPartnerId: string;
    documentType: EBusDocumentType;
    documentTypePartnerId: string;
    documentNumber: string;
    ticketType: EBusTicketType;
    ticketTypePartnerId: string;
    seatId: string;
    seatPartnerId: string | null;
    blankUrl?: string;
    fullPrice: IPrice;
}

export interface IBusPoint {
    type: string;
    id: number;
    pointKey: null;
    supplierDescription: string;
    title: string | null;
    address: string | null;
    timezone: string | null;
    longitude: string | null;
    latitude: string | null;
    searchSubstitute: boolean;
}

interface IBusPartner {
    registerType: string;
    registerNumber: string;
    name: string;
    legalName: string;
    legalAddress: string;
    actualAddress: string;
    taxationNumber: string;
    timetable: string;
}

interface IBusRide {
    rideId: string;
    supplierId: number;
    busPartner: 'UNITIKI_NEW' | string;
    supplier: IBusPartner | null;
    carrierCode: string;
    carrier: IBusPartner | null;
    departureTime: string;
    arrivalTime?: string;
    duration: number;
    titlePointFrom: IBusPoint;
    titlePointTo: IBusPoint;
    pointFrom: IBusPoint;
    pointTo: IBusPoint;
    price: IPrice;
    fee: IPrice;
    yandexFee: IPrice;
    freeSeats: number;
    ticketLimit: number;
    bus: string;
    routeName: string;
    routeNumber: string;
    benefits: unknown[];
    canPayOffline: boolean;
    bookOnly: boolean;
    onlineRefund: boolean;
    refundConditions: string;
}

export interface IBusOrderItem {
    partner: string;
    orderItemState: string;
    payload: unknown;
    hasTestContext: boolean;
    offerId: string;
    passengers: IBusPassenger[];
    ride: IBusRide;
}

export interface IOrderInfo {
    id: string;
    status: unknown;
    displayOrderType: unknown;
    adminActionToken: string;
    createdAt: string;
    yandexOrderId: string;
    url: string;
    partners: unknown[];
    hotelOrderItems: unknown[];
    aviaOrderItems: unknown[];
    trainOrderItems: unknown[];
    busOrderItems: IBusOrderItem[];
    paymentInfo: unknown[];
    promoCampaigns?: unknown;
    owner: unknown;
    flags: unknown;
    authorizedUsers: unknown[];
    starTrekTicketIds: unknown;
    orderRefunds: unknown;
    workflowId: unknown;
    userActionScheduled: unknown;
    broken: boolean;
    orderPriceInfo: unknown;
    vouchers: unknown;
    paymentSchedule?: unknown;
}

export interface IGetAdminOrderResponse extends IOrderInfo {}
