import CurrencyType from 'types/common/CurrencyType';

import {
    EBusDocumentType,
    EBusGender,
    EBusTicketType,
    IGetAdminOrderResponse,
} from '../IGetAdminOrderResponse';

const MOCK_PARTNER_TICKET_URL_1 =
    'https://testing.api.internal.bus.yandex.net/busfor/tickets/eyJvcmRlcl9zaWQiOiAxNDQ5NjIyNSwgInRpY2tldF9zaWQiOiAxOTUwMjM0N30=/blank';
const MOCK_PARTNER_TICKET_URL_2 =
    'https://testing.api.internal.bus.yandex.net/busfor/tickets/eyJvcmRlcl9zaWQiOiAxNDQ5NjIyNSwgInRpY2tldF9zaWQiOiAxOTUwMjM0NX0=/blank';

const ORDER_MOCK_RESPONSE: IGetAdminOrderResponse = {
    id: '887e2310-05f2-4aa3-8e3b-2bc509bd5a36',
    yandexOrderId: 'YA-3368-4791-9571',
    url:
        'https://travel-test.yandex.ru/my/order/887e2310-05f2-4aa3-8e3b-2bc509bd5a36/',
    adminActionToken: '',
    status: 'OS_FULFILLED',
    displayOrderType: 'DT_BUS',
    partners: ['PT_BUS_UNITIKI'],
    createdAt: '2022-02-15T09:05:06.286922Z',
    owner: null,
    hotelOrderItems: [],
    aviaOrderItems: [],
    trainOrderItems: [],
    busOrderItems: [
        {
            partner: 'PT_BUS',
            orderItemState: 'IS_CONFIRMED',
            payload: null,
            hasTestContext: false,
            offerId: '0b7b216a-a2ae-4508-b335-d24eb554c469',
            passengers: [
                {
                    firstName: 'Илья',
                    middleName: 'Сергеевич',
                    lastName: 'Варламов',
                    birthday: '1989-12-12',
                    gender: EBusGender.MALE,
                    genderPartnerId: '1',
                    citizenship: 'AS',
                    citizenshipPartnerId: '9',
                    documentType: EBusDocumentType.RU_PASSPORT,
                    documentTypePartnerId: '1',
                    documentNumber: '6710059554',
                    ticketType: EBusTicketType.FULL,
                    ticketTypePartnerId: '0',
                    seatId: '18',
                    seatPartnerId: null,
                    blankUrl: MOCK_PARTNER_TICKET_URL_1,
                    fullPrice: {
                        value: 400,
                        currency: CurrencyType.RUB,
                    },
                },
                {
                    firstName: 'Илья 2',
                    middleName: 'Сергеевич 2',
                    lastName: 'Варламов 2',
                    birthday: '1990-12-12',
                    gender: EBusGender.MALE,
                    genderPartnerId: '1',
                    citizenship: 'AS',
                    citizenshipPartnerId: '9',
                    documentType: EBusDocumentType.RU_PASSPORT,
                    documentTypePartnerId: '1',
                    documentNumber: '6710059554',
                    ticketType: EBusTicketType.CHILD,
                    ticketTypePartnerId: '0',
                    seatId: '19',
                    seatPartnerId: null,
                    blankUrl: MOCK_PARTNER_TICKET_URL_2,
                    fullPrice: {
                        value: 200,
                        currency: CurrencyType.RUB,
                    },
                },
            ],
            ride: {
                rideId: 'unitiki-new:eyJyaWRlX3NpZCI6ICIxNjEzMDgifQ==',
                supplierId: 13,
                busPartner: 'UNITIKI_NEW',
                supplier: {
                    registerType: 'COMPANY',
                    registerNumber: '1177746988528',
                    name: 'ООО «Юнитики»',
                    legalName: 'ООО «Юнитики»',
                    legalAddress:
                        '127473, г. Москва, ул. Краснопролетарская, д. 16 стр. 1 пом. XI эт. 1 ком. 4',
                    actualAddress:
                        '127473, г. Москва, ул. Краснопролетарская, д. 16 стр. 1',
                    taxationNumber: '',
                    timetable: 'пн–вс: с 8:00 до 20:00',
                },
                carrierCode: 'ООО "Перевозчик"',
                carrier: null,
                departureTime: '2022-02-28T10:00:00Z',
                arrivalTime: '2022-03-01T01:00:00Z',
                duration: 54000000,
                pointFrom: {
                    type: 'POINT_KEY_TYPE_UNKNOWN',
                    id: 0,
                    pointKey: null,
                    supplierDescription: 'Москва, Павелецкий вокзал',
                    title: null,
                    address: null,
                    timezone: null,
                    longitude: '37.480645',
                    latitude: '55.878825',
                    searchSubstitute: false,
                },
                pointTo: {
                    type: 'POINT_KEY_TYPE_UNKNOWN',
                    id: 0,
                    pointKey: null,
                    supplierDescription:
                        'Санкт-Петербург, метро Обводный канал',
                    title: null,
                    address: null,
                    timezone: null,
                    longitude: '30.357678',
                    latitude: '59.913316',
                    searchSubstitute: false,
                },
                titlePointFrom: {
                    type: 'POINT_KEY_TYPE_SETTLEMENT',
                    id: 213,
                    pointKey: null,
                    supplierDescription: '',
                    title: 'Москва',
                    address: null,
                    timezone: 'Europe/Moscow',
                    longitude: '37.619899',
                    latitude: '55.753676',
                    searchSubstitute: false,
                },
                titlePointTo: {
                    type: 'POINT_KEY_TYPE_SETTLEMENT',
                    id: 2,
                    pointKey: null,
                    supplierDescription: '',
                    title: 'Санкт-Петербург',
                    address: null,
                    timezone: 'Europe/Moscow',
                    longitude: '30.315868',
                    latitude: '59.939095',
                    searchSubstitute: false,
                },
                price: {
                    value: 143,
                    currency: CurrencyType.RUB,
                },
                fee: {
                    value: 0,
                    currency: CurrencyType.RUB,
                },
                yandexFee: {
                    value: 13,
                    currency: CurrencyType.RUB,
                },
                freeSeats: 13,
                ticketLimit: 5,
                bus: '',
                routeName: 'Москва — Санкт-Петербург',
                routeNumber: '',
                benefits: [],
                canPayOffline: false,
                bookOnly: false,
                onlineRefund: true,
                refundConditions:
                    '• До отправления осталось более 2 часов – возвращается 95 %.• До отправления осталось от 2 часов до 1 часа – возвращается 85 %.• До отправления осталось менее 1 часа – денежные средства не возвращаются.• В любое время после отправления – денежные средства не возвращаются.',
            },
        },
    ],
    paymentInfo: [
        {
            trustPaymentId: '620b6cca5b095c9a012c68f3',
            startedAt: '2022-02-15T09:05:15.515Z',
            cancelledAt: null,
            paidAt: '2022-02-15T09:05:32Z',
            refundedAt: null,
            status: 'IS_CLEARED',
            paymentRespCode: 'OTHER',
            paymentRespDesc: '',
            rrn: '934634',
            cardNumber: '555555****4444',
            scroogeUrl:
                'https://scrooge-test.paysys.yandex-team.ru/payments/?purchaseToken=327e8a2752f02396f563d3897f350215',
            paymentUrl:
                'https://trust-test.yandex.ru/web/payment?purchaseToken=327e8a2752f02396f563d3897f350215',
            originalPrice: {
                value: 143,
                currency: 'RUB',
            },
            currentPrice: {
                value: 143,
                currency: 'RUB',
            },
            invoiceItems: [
                {
                    invoiceItemId: 2046769,
                    fiscalItemId: 2673019,
                    fiscalItemType: 'BUS_UNITIKI_NEW_TICKET',
                    moneyAmount: {
                        value: 130,
                        currency: 'RUB',
                    },
                },
                {
                    invoiceItemId: 2046770,
                    fiscalItemId: 2673020,
                    fiscalItemType: 'BUS_UNITIKI_NEW_YANDEX_FEE',
                    moneyAmount: {
                        value: 13,
                        currency: 'RUB',
                    },
                },
            ],
            trustRefunds: null,
            receipts: [
                {
                    url:
                        'https://trust-test.yandex.ru/checks/327e8a2752f02396f563d3897f350215/receipts/327e8a2752f02396f563d3897f350215?mode=pdf',
                    type: 'FRT_ACQUIRE',
                },
            ],
            approvalCode: '457880',
        },
    ],
    paymentSchedule: null,
    authorizedUsers: [
        {
            login: 'yndx-test',
            yandexUid: '',
            role: 'OWNER',
        },
    ],
    starTrekTicketIds: null,
    orderRefunds: null,
    vouchers: [],
    userActionScheduled: false,
    broken: false,
    promoCampaigns: {
        taxi2020: null,
        mir2020: {
            offerEligibility: 'MIR_PROMO_DISABLED',
            paidWithMir: false,
            cashbackAmount: null,
        },
        yandexPlus: null,
    },
    orderPriceInfo: {
        price: {
            value: 143,
            currency: 'RUB',
        },
        originalPrice: {
            value: 143,
            currency: 'RUB',
        },
        discountAmount: {
            value: 0,
            currency: 'RUB',
        },
        currentTotalPaymentsSum: {
            value: 143,
            currency: 'RUB',
        },
        promoCodeApplicationResults: [],
    },
    workflowId: 'a5a021d1-fca6-4a5f-a483-3dd5f45ff85e',
    flags: {
        hasMaskedInfo: false,
        canResendSuccessfulMail: true,
        canResendRefundMail: false,
        canManualRefundAllMoney: true,
        canManualRefundYandexFee: true,
        canManualRefundByFiscalItem: true,
        canRestoreDolphinOrder: false,
        canRegenerateVouchers: false,
        canRefundHotelOrder: false,
        canAmountRefundHotelOrder: false,
        canOnlyFullRefundHotelOrder: false,
        canRefundHotelMoneyOnly: false,
        canModifyHotelOrderDetails: false,
    },
};

export default ORDER_MOCK_RESPONSE;
