import EOriginalPaymentErrorCode from 'types/common/EOriginalPaymentErrorCode';
import {IPromoCampaigns} from './types/IPromoCampaigns';
import EHotelOrderPaymentType from './types/EHotelOrderPaymentType';
import EOrderCancellationDetailsReason from './types/EOrderCancellationDetailsReason';
import EOrderCancellationDetailsField from './types/EOrderCancellationDetailsField';
import EPromoCodesApplication from './types/EPromoCodesApplication';
import EHotelOrderStatus from './types/EHotelOrderStatus';
import IHotelOfferInfo from './types/IHotelOfferInfo/IHotelOfferInfo';
import IHotelGuest from './types/IHotelGuest';
import CurrencyType from 'types/common/CurrencyType';
import IPrice from 'types/common/IPrice';

export interface IOrderPriceResponse {
    amount: string | number;
    currency: CurrencyType;
}

export interface IOrderErrorPaymentResponse {
    code: EOriginalPaymentErrorCode;
    amount: IPrice;
}

export interface IOrderCurrentPaymentResponse {
    amount: IPrice;
    paymentUrl: string;
    type: EHotelOrderPaymentType;
}

export interface IOrderNextPaymentResponse {
    amount: IPrice;
    penaltyIfUnpaid: IPrice;
    paymentEndsAt: string;
}

export interface IOrderPaymentResponse {
    errorInfo?: EOriginalPaymentErrorCode;
    paymentUrl?: string;
    receipts?: {
        type: string;
        url: string;
    }[];
    current?: IOrderCurrentPaymentResponse;
    next?: IOrderNextPaymentResponse;
    error?: IOrderErrorPaymentResponse;
    amountPaid?: IPrice;
    mayBeStarted?: boolean;
    mayBeCancelled?: boolean;
    usesDeferredPayments?: boolean;
}

export interface IOrderGuestsInfoResponse {
    customerEmail: string;
    customerPhone: string;
    guests: IHotelGuest[];
    numAdults: number;
    childAges: number[];
}

export interface IOrderRefundInfoResponse {
    penalty: IOrderPriceResponse;
    refund: IOrderPriceResponse;
    penaltyIntervalIndex: number;
    refundDateTime: string;
}

export interface IOrderConfirmationInfoResponse {
    confirmationId: string;
}

// Дочерний объект заказа: order_cancellation_details, описывающий причины отмены для CANCELLED заказов
// https://st.yandex-team.ru/HOTELS-4653
export interface IOrderCancellationDetailsResponse {
    reason?: EOrderCancellationDetailsReason;
    invalidInputDetails?: {
        fieldType: EOrderCancellationDetailsField;
    }[];
}

export interface IOrderStatusResponse {
    status: string;
    paymentUrl?: string;
    paymentError: string | null;
}

export interface IOrderPriceInfoResponse {
    price: IPrice;
    originalPrice: IPrice;
    discountAmount: IPrice;
    promoCampaigns: IPromoCampaigns;
    promoCodeApplicationResults: IPromoCodeApplicationResultResponse[];
}

export interface IPromoCodeApplicationResultResponse {
    code: string;
    type: EPromoCodesApplication;
    discountAmount?: IPrice;
}

export default interface IGetHotelOrderResponse {
    id: string;
    status: EHotelOrderStatus;
    payment?: IOrderPaymentResponse;
    guestInfo: IOrderGuestsInfoResponse;
    refundInfo?: IOrderRefundInfoResponse;
    cancellationInfoUnfiltered?: IOrderRefundInfoResponse;
    orderInfo: IHotelOfferInfo;
    confirmationInfo: IOrderConfirmationInfoResponse;
    yandexOrderId: string;
    orderCancellationDetails?: IOrderCancellationDetailsResponse | null;
    orderPriceInfo?: IOrderPriceInfoResponse;
}
