const {DATAUI_TVM_DEV_OPTIONS} = require('../constants/common');

const [accessKey, secretAccessKey] = (
    process.env.S3_ROBOT_CREDENTIALS || ''
).split(':');

module.exports = {
    port: process.env.DEV_PORT || 9000,
    environmentConfig: {},
    ...DATAUI_TVM_DEV_OPTIONS,
    servicesAPI: {
        hotelsAPI: 'https://api.travel-balancer-test.yandex.net/api',
    },
    s3Settings: {
        accessKey,
        secretAccessKey,
        s3Host: 'https://s3.mdst.yandex.net',
        s3BucketName: 'hotel-order-voucher',
    },
    loggingLevel: 'warn',
};
