const {resolve} = require('path');

const [accessKey, secretAccessKey] = (
    process.env.S3_ROBOT_CREDENTIALS || ''
).split(':');

module.exports = {
    socket: resolve(__dirname, '../run/node.sock'),
    environmentConfig: {},
    servicesAPI: {
        hotelsAPI: 'https://api-prod.travel-hotels.yandex.net/api',
    },
    s3Settings: {
        accessKey,
        secretAccessKey,
        s3Host: 'https://s3.mds.yandex.net',
        s3BucketName: 'hotel-order-voucher',
    },
};
