import uniq from 'lodash/uniq';

import {isNotNull} from 'types/utilities';
import {IBusOrderItem} from '../../../api/TravelApi/types/getAdminOrder/IGetAdminOrderResponse';

export default function getUniqPartnersTicketsUrls(
    busOrderItem: IBusOrderItem,
): string[] {
    const partnersTicketsUrls = busOrderItem.passengers
        .map(passenger => passenger.blankUrl || null)
        .filter(isNotNull);

    /*
     * Юнитики возвращают pdf со всеми билетами, поэтому для них не нужно мержить pdf'ки
     */
    return busOrderItem.ride.busPartner === 'UNITIKI_NEW'
        ? partnersTicketsUrls.slice(0, 1)
        : uniq(partnersTicketsUrls);
}
