import PDFMerger from 'pdf-merger-js';

import getTempPdfLocation from './getTempPdfLocation';

export default async function mergeAndWriteTicketToDisk(
    baseFileName: string,
    ticketsPdfsPaths: string[],
): Promise<string> {
    const merger = new PDFMerger();

    ticketsPdfsPaths.forEach(filePath => {
        merger.add(filePath);
    });

    const mergedPdfTempLocation = getTempPdfLocation(baseFileName);

    await merger.save(mergedPdfTempLocation);

    return mergedPdfTempLocation;
}
