import TRequest from 'server/types/TRequest';
import TResponse from 'server/types/TResponse';

import handleAppError from 'server/utilities/handleAppError';
import buildErrorFromUnknown from 'server/utilities/AppError/buildErrorFromUnknown';

import state from 'server/controllers/pdfController/state';
import generateVoucher from 'server/controllers/pdfController/generateVoucher';
import generateBusesTickets from 'server/controllers/pdfController/generateBusesTickets';
import generateHotelVoucher from 'server/controllers/pdfController/generateHotelVoucher';
import generateHotelBusinessTripDoc from 'server/controllers/pdfController/generateHotelBusinessTripDoc';

const projectApiControllerByType: Record<
    string,
    (req: TRequest, resp: TResponse) => Promise<void>
> = {
    generate: generateVoucher,
    generateHotelVoucher,
    generateBusesTickets,
    generateHotelBusinessTripDoc,
    state,
};

export default () => async (req: TRequest, res: TResponse): Promise<void> => {
    const {params} = req;
    const {action} = params;

    const actionController = projectApiControllerByType[action];

    if (typeof actionController === 'function') {
        try {
            await actionController(req, res);
        } catch (e) {
            handleAppError(buildErrorFromUnknown(e), req, res);
        }

        return;
    }

    res.status(404).send();
};
