import {Agent} from 'https';
import {S3} from '@aws-sdk/client-s3';
import {NodeHttpHandler} from '@aws-sdk/node-http-handler';

import {IS3Settings} from 'server/types/TRequest';

const httpsAgent = new Agent({rejectUnauthorized: false});

export default function s3Client(s3Settings: IS3Settings): S3 {
    const {s3Host, accessKey, secretAccessKey} = s3Settings;

    return new S3({
        endpoint: s3Host,
        region: 'eu-central-1',
        credentials: {
            accessKeyId: accessKey,
            secretAccessKey: secretAccessKey,
        },
        requestHandler: new NodeHttpHandler({httpsAgent}),
    });
}
