import {CoreLogger} from '@yandex-data-ui/core/build/types';
import {IS3Settings} from 'server/types/TRequest';

import buildErrorFromUnknown from 'server/utilities/AppError/buildErrorFromUnknown';

import s3Client from './s3Client';

interface IS3ClientParams {
    fileContent: Buffer;
    fileName: string;
    logger: CoreLogger;
    orderId: string;
    s3Settings: IS3Settings;
}

export default async function saveFileToS3({
    fileContent,
    fileName,
    logger,
    orderId,
    s3Settings,
}: IS3ClientParams): Promise<string> {
    const {s3Host, s3BucketName} = s3Settings;

    const s3 = s3Client(s3Settings);

    try {
        const params = {Bucket: s3BucketName, Key: fileName, Body: fileContent};

        logger.log('VOUCHER_S3_START', {orderId});

        await s3.putObject(params);

        logger.log('VOUCHER_S3_SUCCESS', {orderId});

        return `${s3Host}/${s3BucketName}/${fileName}`;
    } catch (e) {
        logger.logError('VOUCHER_S3_ERROR', buildErrorFromUnknown(e), {
            orderId,
        });

        throw new Error('VOUCHER_S3_ERROR');
    }
}
