import {IServerDataFetcherBag} from 'server/redux/types';
import {EOrderRequestSnippet} from '../../api/TravelApi/types/getAdminOrder/IGetAdminOrderRequest';

import orderReducer from 'reducers/order/order';

import {OrderIdError} from 'server/utilities/AppError/errors';

import TravelApi from 'server/api/TravelApi/TravelApi';

export default async function fetchOrderInfo({
    dispatch,
    req,
}: IServerDataFetcherBag): Promise<void> {
    const {orderId} = req.query;

    if (typeof orderId !== 'string') {
        throw new OrderIdError(orderId);
    }

    try {
        const travelApi = new TravelApi(req);

        const order = await travelApi.getAdminOrder({
            id: orderId,
            snippets: EOrderRequestSnippet.S_PRIVATE_INFO,
        });

        const status = order.busOrderItems[0].orderItemState;

        if (status === 'IS_CONFIRMED') {
            dispatch(orderReducer.actions.setOrder(order));

            return;
        }

        req.utils.logWarn(`Order ${orderId} is not CONFIRMED`);
    } catch (e) {
        req.utils.logError('FETCH_ORDER_ERROR', e, {
            level: 'travel API',
            data: `actionType: fetchOrderInfo, orderId: ${orderId}`,
        });
    }
}
