import {Store} from 'redux';

import TRequest from 'server/types/TRequest';
import {IServerDataFetcherBag} from '../types';

import {IStoreInterface} from 'reducers/rootReducer';

export type TFetcher = (bag: IServerDataFetcherBag) => Promise<void>;

export default function fetchProjectReduxInfo(
    req: TRequest,
    reduxStore: Store<IStoreInterface>,
    fetchDataList: TFetcher[],
): Promise<unknown> {
    const {dispatch, getState} = reduxStore;

    return Promise.all(
        fetchDataList.map(fetchServerData =>
            fetchServerData({dispatch, getState, req}),
        ),
    ).catch(e => {
        req.utils.logWarn('FAILED_FETCH_PROJECT_REDUX_INFO', e);
    });
}
