import {IServerDataFetcherBag} from 'server/redux/types';

import businessTripDoc from 'reducers/hotels/businessTripDoc';

import {OrderIdError} from 'server/utilities/AppError/errors';

import TravelApi from 'server/api/TravelApi/TravelApi';

export default async function fetchBusinessTripDoc({
    dispatch,
    req,
}: IServerDataFetcherBag): Promise<void> {
    const id = req.query.orderId;

    if (typeof id !== 'string') {
        throw new OrderIdError(id);
    }

    try {
        const travelApi = new TravelApi(req);

        const order = await travelApi.getOrderForBusinessTripDoc({orderId: id});

        dispatch(businessTripDoc.actions.setOrder(order));
    } catch (e) {
        req.utils.logError('FETCH_BUSINESS_TRIP_DOC_ERROR', e, {
            level: 'travel API',
            data: `actionType: fetchBusinessTripDoc, orderId: ${id}`,
        });
    }
}
