import EHotelOrderStatus from 'server/api/TravelApi/types/getHotelOrder/IGetHotelOrderResponse/types/EHotelOrderStatus';
import {IServerDataFetcherBag} from 'server/redux/types';

import hotelOrder from 'reducers/hotels/hotelOrder';

import {OrderIdError} from 'server/utilities/AppError/errors';

import TravelApi from 'server/api/TravelApi/TravelApi';

export default async function fetchOrderInfo({
    dispatch,
    req,
}: IServerDataFetcherBag): Promise<void> {
    const id = req.query.orderId;

    if (typeof id !== 'string') {
        throw new OrderIdError(id);
    }

    try {
        const travelApi = new TravelApi(req);

        const order = await travelApi.getHotelOrder({id});

        if (order.status === EHotelOrderStatus.CONFIRMED) {
            dispatch(hotelOrder.actions.setOrder(order));

            return;
        }

        req.utils.logWarn(`Order ${id} is not CONFIRMED`);
    } catch (e) {
        req.utils.logError('HOTELS_ERROR', e, {
            level: 'hotels API',
            data: `actionType: fetchOrderInfo, orderId: ${id}`,
        });
    }
}
