import React from 'react';
import htmlEscape from 'htmlescape';

import {IStoreInterface} from 'reducers/rootReducer';

interface IHtmlContainerProps {
    styleElements: React.ReactNode[];
    scriptElements: React.ReactNode[];
    linkElements: React.ReactNode[];
    reduxState: IStoreInterface;
    nonce: string;
}

const HtmlContainer: React.FC<IHtmlContainerProps> = props => {
    const {
        styleElements,
        linkElements,
        scriptElements,
        reduxState,
        nonce,
        children,
    } = props;

    const preLoadedReduxState = `window.__PRELOADED_REDUX_STATE__ = ${htmlEscape(
        reduxState,
    )}`;

    return (
        <html>
            <head>
                <title>Yandex Travel PDF</title>
                <meta charSet="utf-8" />
                <meta
                    name="viewport"
                    content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no"
                />
                <meta name="robots" content="noyaca" />
                {styleElements}
                {linkElements}
            </head>
            <body>
                <div id="app">{children}</div>
                <script
                    nonce={nonce}
                    dangerouslySetInnerHTML={{__html: preLoadedReduxState}}
                />
                {scriptElements}
            </body>
        </html>
    );
};

export default HtmlContainer;
