import {Request} from '@yandex-data-ui/core/build/types';

import EServiceName from './EServiceName';

export type TEntryServices = Partial<Record<EServiceName, string>>;

export interface IS3Settings {
    accessKey: string;
    secretAccessKey: string;
    s3Host: string;
    s3BucketName: string;
}

type TRequest = Request & {
    utils: {
        config: {
            servicesAPI: TEntryServices;
            s3Settings: IS3Settings;
        };
    };
};

export default TRequest;
