interface IAppErrorArgs {
    /**
     * HTTP status
     */
    code?: number | string;
    /**
     * Текст в лог, если не передан будет Error.message
     */
    logMessage?: string;
    /**
     * Объект с дополнительной информацией для лога
     */
    extra?: Object;
    /**
     * Оригинальный объект ошибки для лога
     */
    originalError?: Error;
    /**
     * Что отправить в теле ответа, по умолчанию Error.message
     */
    body?: any;
}

export default class AppError extends Error {
    private static normalizeStatusCode(
        code: string | number | undefined,
    ): number {
        const defaultStatusCode = 500;

        if (!code) {
            return defaultStatusCode;
        }

        const num = Number(code);

        if (isNaN(num)) {
            return defaultStatusCode;
        }

        return num;
    }

    code: number;
    logMessage: string;
    extra?: Object;
    originalError?: Error;
    body?: any;

    constructor(message: string, args: IAppErrorArgs = {}) {
        super(message);

        this.code = AppError.normalizeStatusCode(args.code);
        this.logMessage = args.logMessage || message;
        this.extra = args.extra;
        this.originalError = args.originalError;
        this.body = args.body;
    }
}
