import {EProjectName} from 'server/constants/EProjectName';

import AppError from './AppError';

const EMPTY_ORDER_ID_ERROR_MAP: Record<EProjectName, string> = {
    [EProjectName.BUSES]: 'BUSES_TICKETS_EMPTY_ORDER_ID',
    [EProjectName.HOTELS]: 'HOTELS_VOUCHER_EMPTY_ORDER_ID',
};

const GENERATE_ERROR_MAP: Record<EProjectName, string> = {
    [EProjectName.BUSES]: 'BUSES_TICKETS_GENERATE_ERROR',
    [EProjectName.HOTELS]: 'HOTELS_VOUCHER_GENERATE_ERROR',
};

export class FileNameError extends AppError {
    constructor(fileName: unknown) {
        super('QUERY_FILE_NAME_IS_NOT_STRING', {
            code: 404,
            body: {error: {code: 'FILE_NAME_IS_NOT_STRING'}},
            extra: {
                fileName,
            },
        });
    }
}

export class OrderIdError extends AppError {
    constructor(orderId: unknown) {
        super('QUERY_ORDER_ID_IS_NOT_STRING', {
            code: 404,
            body: {error: {code: 'ORDER_ID_IS_NOT_STRING'}},
            extra: {
                orderId,
            },
        });
    }
}

export class EmptyOrderIdError extends AppError {
    constructor(projectName: EProjectName) {
        super(EMPTY_ORDER_ID_ERROR_MAP[projectName], {
            code: 404,
            body: {error: {code: 'UNKNOWN_ORDER_ID'}},
        });
    }
}

export class GenerateError extends AppError {
    constructor(projectName: EProjectName, orderId: unknown, e?: Error) {
        super(GENERATE_ERROR_MAP[projectName], {
            code: 502,
            originalError: e,
            extra: {orderId},
            body: {error: {code: 'PRINT_PDF_ORDER_ERROR'}},
        });
    }
}
