import EServiceName from 'server/types/EServiceName';
import TRequest from 'server/types/TRequest';

export default function getServiceApiEntry(
    req: TRequest,
    serviceName: EServiceName,
): string {
    const apiEntry = req?.utils?.config?.servicesAPI?.[serviceName];

    if (!apiEntry) {
        throw new Error(`Entry not specified for service: ${apiEntry}`);
    }

    return apiEntry;
}
