import EServiceName from 'server/types/EServiceName';
import TRequest from 'server/types/TRequest';

export default function getServiceTVMTicket(
    req: TRequest,
    serviceName: EServiceName,
): string {
    const {tvm} = req;

    if (!tvm) {
        throw new Error('TVM middleware out of service');
    }

    const serviceTVM = tvm.tickets[serviceName];

    if (!serviceTVM.ticket) {
        throw new Error(serviceTVM.error || `No ticket for service: ${name}`);
    }

    return serviceTVM.ticket;
}
