import TRequest from 'server/types/TRequest';
import TResponse from 'server/types/TResponse';

import AppError from 'server/utilities/AppError/AppError';

export default function handleAppError(
    error: Error,
    req: TRequest,
    res: TResponse,
): void {
    if (error instanceof AppError) {
        const {code} = error;
        const logParams = [
            error.logMessage,
            error.originalError,
            error.extra,
        ] as const;

        if (code >= 400 && code < 500) {
            req.utils.logWarn(...logParams);
        } else {
            req.utils.logError(...logParams);
        }

        res.status(error.code).send(error.body || error.message);

        return;
    }

    req.utils.logError(error.message, error);
    res.status(500).send(error.message);

    return;
}
