import 'core-js';
import React from 'react';
import ReactDOM from 'react-dom';
import {Provider} from 'react-redux';
import {Router} from 'react-router-dom';
import 'moment-timezone';
import {loadableReady} from '@loadable/component';

import browserHistory from 'utilities/browserHistory/browserHistory';
import checkDocumentOnLoad from './helpers/checkDocumentOnLoad';
import {setDateLocale} from 'utilities/dateUtils';
import locales from 'utilities/dateUtils/locales';

import App from 'containers/App/App';

import createReduxStore from './redux/createReduxStore';

const reduxStore = createReduxStore();
const rootNode = document.getElementById('app');

setDateLocale(locales.RU);

(async (): Promise<void> => {
    await checkDocumentOnLoad();
    await loadableReady();

    ReactDOM.hydrate(
        <Provider store={reduxStore}>
            <Router
                // @ts-ignore
                history={browserHistory}
            >
                <App />
            </Router>
        </Provider>,
        rootNode,
    );
})();
