import React from 'react';

import {IWithClassName} from 'types/IWithClassName';

import * as i18n from 'i18n/hotels-BookVoucherPDF';

import {
    Copyright as LegoCopyright,
    CopyrightProps,
} from '@yandex-lego/draft-components/Copyright';

import cx from './Copyright.scss';

interface ICopyrightProps extends IWithClassName, CopyrightProps {}

const Copyright: React.FC<ICopyrightProps> = props => {
    const {className} = props;

    return (
        <LegoCopyright start={2009} className={cx('root', className)}>
            {i18n.footerCompanyName()}
        </LegoCopyright>
    );
};

export default Copyright;
