import React from 'react';

import {IWithClassName} from 'types/IWithClassName';

import * as i18n from 'i18n/hotels-BookVoucherPDF';

import YandexTravelLogo from 'components/YandexTravelLogo/YandexTravelLogo';
import SupportPhone from 'components/SupportPhone/SupportPhone';
import Copyright from 'components/Copyright/Copyright';

import cx from './Layout.scss';

interface ILayoutProps extends IWithClassName {
    supportPhone: string | null;
}

const Layout: React.FC<ILayoutProps> = props => {
    const {className, supportPhone, children} = props;

    return (
        <div className={cx('root', className)}>
            <header className={cx('header')}>
                <div className={cx('headerContent')}>
                    <YandexTravelLogo />
                    {supportPhone && (
                        <div className={cx('support')}>
                            <h5 className={cx('supportTitle')}>
                                {i18n.supportTitle()}
                            </h5>
                            <SupportPhone supportPhone={supportPhone} />
                        </div>
                    )}
                </div>
            </header>
            <section className={cx('body')}>{children}</section>
            <footer className={cx('footer')}>
                <section className={cx('footerContent')}>
                    <Copyright />
                </section>
            </footer>
        </div>
    );
};

export default Layout;
