import React, {useCallback} from 'react';
import {Route, RouteComponentProps} from 'react-router-dom';

interface IRouteWithStatusCodeProps {
    statusCode: number;
}

const RouteWithStatusCode: React.FC<IRouteWithStatusCodeProps> = props => {
    const {statusCode} = props;

    const render = useCallback(
        ({staticContext}: RouteComponentProps) => {
            if (staticContext) {
                staticContext.statusCode = statusCode;
            }

            return null;
        },
        [statusCode],
    );

    return <Route render={render} />;
};

export default RouteWithStatusCode;
