import React, {CSSProperties, FunctionComponent} from 'react';

import {IWithClassName} from 'types/IWithClassName';

import cx from './Separator.scss';

export interface ISeparatorProps extends IWithClassName {
    /**
     * Марджин со всех сторон, в px
     */
    margin?: number;

    borderWidth?: CSSProperties['borderWidth'];
    borderStyle?: CSSProperties['borderStyle'];
}

const Separator: FunctionComponent<ISeparatorProps> = ({
    className,
    margin = 0,
    borderWidth = 1,
    borderStyle = 'solid',
}) => (
    <div
        className={cx('root', className)}
        style={{
            marginTop: margin,
            marginBottom: margin,
            borderWidth,
            borderStyle,
        }}
    />
);

export default Separator;
