import React from 'react';

import {IWithClassName} from 'types/IWithClassName';

import cx from './SupportPhone.scss';

interface ISupportPhoneProps extends IWithClassName {
    supportPhone: string;
}

const SupportPhone: React.FC<ISupportPhoneProps> = props => {
    const {className, supportPhone} = props;

    return (
        <a
            className={cx('root', className)}
            href={`tel:${supportPhone.replace(/\D/g, '')}`}
        >
            {supportPhone}
        </a>
    );
};

export default SupportPhone;
