import React from 'react';

import {IWithClassName} from 'types/IWithClassName';

import DesktopIndexLogoYandex from './images/DesktopIndexLogoYandex';
import DesktopIndexLogoTravelSign from './images/DesktopIndexLogoTravelSign';
import DesktopIndexLogoTravel from './images/DesktopIndexLogoTravel';

import cx from './YandexTravelLogo.scss';

interface IYandexTravelLogoProps extends IWithClassName {}

const YandexTravelLogo: React.FC<IYandexTravelLogoProps> = props => {
    const {className} = props;

    return (
        <div className={cx('yandexTravelLogo', className)}>
            <DesktopIndexLogoYandex className={cx('yandexLogoSign')} />
            <DesktopIndexLogoTravelSign className={cx('travelLogoSign')} />
            <DesktopIndexLogoTravel className={cx('travelLogoLabel')} />
        </div>
    );
};

export default React.memo(YandexTravelLogo);
