import React from 'react';

import {IIconProps} from 'types/IIconProps';

const DesktopIndexLogoTravelSign: React.FC<IIconProps> = props => (
    <svg
        viewBox="0 0 29 30"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <rect
            width={27.58}
            height={27.58}
            rx={13.79}
            transform="matrix(1 -8.74228e-08 -8.74228e-08 -1 0.609863 28.5781)"
            fill="#FED42B"
        />
        <mask
            id="2cd73fcd__mask0_30829_5177"
            style={{
                maskType: 'alpha',
            }}
            maskUnits="userSpaceOnUse"
            x={0}
            y={1}
            width={29}
            height={28}
        >
            <circle cx={14.3999} cy={14.79} r={13.79} fill="white" />
        </mask>
        <g mask="url(#2cd73fcd__mask0_30829_5177)">
            <rect
                x={0.609863}
                y={1}
                width={27.58}
                height={27.58}
                fill="url(#2cd73fcd__paint0_linear_30829_5177)"
            />
            <path
                d="M19.895 5.35889C18.9613 5.35889 18.0732 5.42273 17.3302 5.67428C16.5313 5.94475 15.8481 6.45346 15.4846 7.31631C15.1661 8.07216 15.0544 8.48271 14.7485 9.87344C14.5988 10.5545 14.9486 11.164 15.5836 11.3378C16.2185 11.5116 16.8927 11.118 17.0665 10.4831C17.3504 9.24839 17.4096 8.93294 17.6116 8.41433C17.7083 8.16602 17.8299 8.02195 18.0947 7.93231C18.4533 7.81088 19.018 7.74281 19.895 7.74281C20.4885 7.74281 20.8933 7.80843 21.153 7.88919C21.4372 7.97762 21.5238 8.14282 21.4663 8.44266C21.3397 9.10191 21.2525 9.50069 21.1222 10.1592C20.9943 10.8049 21.4142 11.4321 22.06 11.5599C22.7058 11.6877 23.3329 11.2679 23.4607 10.6221C23.6381 9.7261 23.8363 8.83172 23.8833 8.18961C23.959 7.15494 23.4281 6.38928 22.5468 5.90148C21.8168 5.49737 20.8815 5.35889 19.895 5.35889Z"
                fill="#BD0C42"
            />
            <path
                d="M11.1601 12.3252L11.1605 12.3252C13.1607 12.3263 15.1609 12.3259 17.1612 12.3256C18.1474 12.3254 19.1336 12.3252 20.1199 12.3252C22.5951 12.3236 24.3738 13.9794 24.3665 16.4935C24.363 17.685 24.2431 19.5397 24.06 21.5424C23.8545 23.7903 23.5608 26.35 23.2204 28.58H20.7122C21.1164 26.0298 21.4338 23.4658 21.6702 20.8946C21.8251 19.2094 21.9333 18.0324 21.9205 16.7291C21.9066 15.3187 21.2754 14.702 19.9321 14.702H11.3386C9.37787 14.702 8.09995 14.8495 7.26035 16.8062C6.79583 17.8887 6.08708 20.1249 5.57596 22.8124C5.24128 24.5722 4.9983 26.6803 4.95679 28.58H2.51074C2.55374 26.4672 2.82527 24.353 3.18591 22.4567C3.73236 19.5834 4.50002 17.1256 5.05584 15.8302C6.24853 13.0507 8.32352 12.3237 11.1601 12.3252Z"
                fill="#FF6D3A"
            />
            <path
                d="M17.2928 28.58H14.8101C15.0059 24.1419 15.8795 19.615 16.8394 16.9297C17.0699 16.2847 17.7796 15.9487 18.4246 16.1793C19.0696 16.4098 19.4055 17.1196 19.175 17.7645C18.313 20.176 17.4879 24.4074 17.2928 28.58Z"
                fill="#FF6D3A"
            />
        </g>
        <defs>
            <linearGradient
                id="2cd73fcd__paint0_linear_30829_5177"
                x1={28.0793}
                y1={0.87975}
                x2={0.934648}
                y2={28.5899}
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#FFEB75" />
                <stop offset={0.920669} stopColor="#FEE14A" />
            </linearGradient>
        </defs>
    </svg>
);

export default DesktopIndexLogoTravelSign;
