import qs from 'query-string';

export const root = '/';
export const hotelsBookVoucher = '/hotels/bookVoucher';
export const hotelsBusinessTripDoc = '/hotels/businessTripDoc';
export const busesTicket = '/buses/ticket';

export function getHotelsBookVoucherUrl(
    origin: string,
    params: {orderId: string},
): string {
    return `https://${origin}${hotelsBookVoucher}?${qs.stringify(params)}`;
}

export function getHotelsBusinessTripDocUrl(
    origin: string,
    params: {orderId: string},
): string {
    return `https://${origin}${hotelsBusinessTripDoc}?${qs.stringify(params)}`;
}

export function getBusesTicketUrl(
    origin: string,
    params: {orderId: string; passengerIndex: number},
): string {
    return `https://${origin}${busesTicket}?${qs.stringify(params)}`;
}
