import React from 'react';
import {Route, Switch, withRouter, RouteComponentProps} from 'react-router-dom';
import {hot as reactHotLoaderDecorator} from 'react-hot-loader';

import {
    busesTicket,
    hotelsBookVoucher,
    hotelsBusinessTripDoc,
    root,
} from 'constants/urls';

import NotFoundPage from 'components/NotFound/NotFoundPage';

import BookVoucher from 'projects/hotels/pages/BookVoucher/BookVoucher';
import Ticket from 'projects/buses/pages/Ticket/Ticket';
import BusinessTripDoc from 'projects/hotels/pages/BusinessTripDoc/BusinessTripDoc';
import IndexPage from 'projects/index/pages/IndexPage';

import cx from './App.scss';

interface IAppProps extends RouteComponentProps {}

@reactHotLoaderDecorator(module)
class App extends React.Component<IAppProps> {
    render(): React.ReactNode {
        return (
            <div className={cx('App')}>
                <Switch>
                    <Route exact path={root} component={IndexPage} />
                    <Route
                        exact
                        path={hotelsBookVoucher}
                        component={BookVoucher}
                    />
                    <Route
                        exact
                        path={hotelsBusinessTripDoc}
                        component={BusinessTripDoc}
                    />
                    <Route exact path={busesTicket} component={Ticket} />
                    <Route component={NotFoundPage} />
                </Switch>
            </div>
        );
    }
}

export default withRouter(App);
