/* global __SERVER__ */
import React, {Component, ComponentType, createContext} from 'react';

import {TFetcher} from '../../server/redux/common/fetchProjectReduxInfo';

const defaultValue = null;

export const ServerFetchDataContext = createContext<TFetcher[] | null>(
    defaultValue,
);

interface IServerFetchDataProviderProps {
    fetchDataList: TFetcher[];
}

export const ServerFetchDataProvider: React.FC<IServerFetchDataProviderProps> = props => {
    const {fetchDataList, children} = props;

    return (
        <ServerFetchDataContext.Provider value={fetchDataList}>
            {children}
        </ServerFetchDataContext.Provider>
    );
};

interface IServerFetchDataSetterProps {
    fetchDataList: TFetcher[];
    serverFetchList: TFetcher[];
}

class ServerFetchDataSetter extends Component<IServerFetchDataSetterProps> {
    static defaultProps = {
        serverFetchList: [],
    };

    constructor(props: IServerFetchDataSetterProps) {
        super(props);

        const {fetchDataList} = props;

        if (__SERVER__ && fetchDataList) {
            const {serverFetchList} = props;

            fetchDataList.push(...serverFetchList);
        }
    }

    render(): React.ReactNode {
        return null;
    }
}

interface IFetchDataDispatcherOptions {
    checkNested?: boolean;
}

export const serverFetchDataDispatcher = (
    serverFetchList: TFetcher[],
    {checkNested = false}: IFetchDataDispatcherOptions = {},
) =>
    function<P>(PageComponent: ComponentType<P>): ComponentType<P> {
        if (__SERVER__) {
            return (props: P): React.ReactElement => {
                const ServerFetchDataConsumerFactory = (
                    <ServerFetchDataContext.Consumer>
                        {(fetchDataList): React.ReactElement =>
                            fetchDataList ? (
                                <React.Fragment>
                                    <ServerFetchDataSetter
                                        fetchDataList={fetchDataList}
                                        serverFetchList={serverFetchList}
                                    />
                                    {checkNested && (
                                        <PageComponent {...props} />
                                    )}
                                </React.Fragment>
                            ) : (
                                <PageComponent {...props} />
                            )
                        }
                    </ServerFetchDataContext.Consumer>
                );

                return ServerFetchDataConsumerFactory;
            };
        }

        return PageComponent;
    };
