import React, {memo, FC} from 'react';

import {IBusPassenger} from '../../../../../../../server/api/TravelApi/types/getAdminOrder/IGetAdminOrderResponse';

import getFullName from 'projects/buses/pages/Ticket/components/Passenger/utilities/getFullName';
import getGender from 'projects/buses/pages/Ticket/components/Passenger/utilities/getGender';
import getBirthdate from 'projects/buses/pages/Ticket/components/Passenger/utilities/getBirthdate';
import getTariffName from 'projects/buses/pages/Ticket/components/Passenger/utilities/getTariffName';

import * as i18n from 'i18n/bus-Ticket';

import Text from 'components/Text/Text';

import cx from './Passenger.scss';

interface IPassengerProps {
    passenger: IBusPassenger;
}

const Passenger: FC<IPassengerProps> = props => {
    const {passenger} = props;

    const fullName = getFullName(passenger);
    const gender = getGender(passenger);
    const birthdate = getBirthdate(passenger);
    const tariffName = getTariffName(passenger);

    return (
        <div className={cx('root')}>
            <div className={cx('passenger')}>
                <Text
                    className={cx('passengerTitle')}
                    size="xs"
                    color="secondary"
                >
                    {i18n.passengerTitle()}
                </Text>

                <div>{fullName}</div>

                <div className={cx('passengerInfo')}>
                    <div>{i18n.document()}</div>
                    <div>{passenger.documentNumber}</div>
                    <div>{birthdate}</div>
                    {gender && <div>{gender}</div>}
                </div>
            </div>

            <div className={cx('place')}>
                <Text className={cx('placeTitle')} size="xs" color="secondary">
                    {i18n.placeTitle()}
                </Text>

                {passenger.seatId && <div>{passenger.seatId}</div>}

                <div>
                    {tariffName}: {passenger.fullPrice.value}{' '}
                    {passenger.fullPrice.currency}
                </div>
            </div>
        </div>
    );
};

export default memo(Passenger);
