import {
    EBusGender,
    IBusPassenger,
} from '../../../../../../../../server/api/TravelApi/types/getAdminOrder/IGetAdminOrderResponse';

import * as i18n from 'i18n/bus-Ticket';

export default function getGender(passenger: IBusPassenger): string | null {
    switch (passenger.gender) {
        case EBusGender.MALE: {
            return i18n.maleGender();
        }

        case EBusGender.FEMALE: {
            return i18n.femaleGender();
        }

        default: {
            return null;
        }
    }
}
