import {
    EBusTicketType,
    IBusPassenger,
} from '../../../../../../../../server/api/TravelApi/types/getAdminOrder/IGetAdminOrderResponse';

import * as i18n from 'i18n/bus-Ticket';

export default function getTariffName(passenger: IBusPassenger): string {
    switch (passenger.ticketType) {
        case EBusTicketType.FULL: {
            return i18n.fullTicketType();
        }

        case EBusTicketType.CHILD: {
            return i18n.childTicketType();
        }

        case EBusTicketType.BAGGAGE: {
            return i18n.baggageTicketType();
        }
    }
}
