import React, {memo, FC} from 'react';

import {IBusPoint} from '../../../../../../../server/api/TravelApi/types/getAdminOrder/IGetAdminOrderResponse';

import * as i18n from 'i18n/bus-Ticket';

import Point from 'projects/buses/pages/Ticket/components/RouteInfo/components/Point/Point';
import Description from 'projects/buses/pages/Ticket/components/RouteInfo/components/Description/Description';
import ArrowRight from 'projects/buses/pages/Ticket/components/RouteInfo/components/ArrowRight/ArrowRight';

import cx from './RouteInfo.scss';

interface IRouteInfoProps {
    departureTime: string;
    arrivalTime?: string;
    titlePointFrom: IBusPoint;
    titlePointTo: IBusPoint;
    pointFrom: IBusPoint;
    pointTo: IBusPoint;
    routeName: string;
}

function getPointTitle(point: IBusPoint): string {
    return point.title || point.supplierDescription;
}

const RouteInfo: FC<IRouteInfoProps> = props => {
    const {
        departureTime,
        arrivalTime,
        titlePointFrom,
        pointFrom,
        titlePointTo,
        pointTo,
        routeName,
    } = props;

    const fromTitle = getPointTitle(titlePointFrom);
    const toTitle = getPointTitle(titlePointTo);
    const fromDescription = getPointTitle(pointFrom);
    const toDescription = getPointTitle(pointTo);

    return (
        <div>
            <div className={cx('points')}>
                <Point
                    className={cx('point')}
                    title={i18n.pointDepartureTitle()}
                    time={departureTime}
                    pointTitle={fromTitle}
                    pointDescription={fromDescription}
                />

                <ArrowRight className={cx('arrow')} />

                <Point
                    className={cx('point')}
                    title={i18n.pointArrivalTitle()}
                    time={arrivalTime}
                    pointTitle={toTitle}
                    pointDescription={toDescription}
                />
            </div>

            <Description className={cx('routeDescription')} text={routeName} />
        </div>
    );
};

export default memo(RouteInfo);
